/*
 * $Id: pgpElGKey.h,v 1.4 2001/01/25 22:11:31 jeffc Exp $
 */

#ifndef Included_pgpElGKey_h
#define Included_pgpElGKey_h

#include "pgpPubTypes.h"	/* For PGPByte */
#include "pgpOpaqueStructs.h"

PGP_BEGIN_C_DECLARATIONS

/* Bits for uniqueness of p, q */
#define ELGDUMMYBITS	64

PGPPubKey *	elgPubFromBuf( PGPContextRef context,
				PGPByte const *buf, PGPSize len, PGPError *error);
				
PGPSecKey *	elgSecFromBuf( PGPContextRef context,
				PGPByte const *buf, PGPSize len, PGPError *error);
			
int			elgPubKeyPrefixSize(PGPByte const *buf, PGPSize size);

PGPSecKey *	elgSecGenerate(PGPContextRef context,
				unsigned bits, PGPBoolean fastgen,
				PGPRandomContext const *rc,
				int progress(void *arg, int c), void *arg, PGPError *error);

PGP_END_C_DECLARATIONS

#endif /* Included_pgpElGKey_h */
